#include "config.h"
char const * VERSION = "1.0";
bool global_can_enable_editor = 1;
bool global_use_touch_input = 0;
Controls controls;
void config_controls_read(void) {
    controls.c [ControlLeft] [0] = LandKeyLeft;
    controls.c [ControlLeft] [1] = 'a';
    controls.c [ControlRight] [0] = LandKeyRight;
    controls.c [ControlRight] [1] = 'd';
    controls.c [ControlUp] [0] = LandKeyUp;
    controls.c [ControlUp] [1] = 'w';
    controls.c [ControlDown] [0] = LandKeyDown;
    controls.c [ControlDown] [1] = 's';
    controls.c [ControlJump] [0] = LandKeyLeftControl;
    controls.c [ControlJump] [1] = LandKeyRightControl;
    controls.c [ControlJump] [2] = LandKeyEnter;
    controls.c [ControlMenu] [0] = LandKeyBackspace;
    int an = land_joystick_axis_count();
    for (int ai = 1; ai < an; ai += 1) {
        str axis = land_joystick_axis_name(ai);
        if (land_equals("Stick 1 X", axis) || land_equals("Left Thumbstick X", axis)) {
            controls.axis [ControlLeft] [0] = ai;
            controls.axis [ControlLeft] [1] = - 25;
            controls.axis [ControlRight] [0] = ai;
            controls.axis [ControlRight] [1] = 25;
        }
        if (land_equals("Stick 1 Y", axis) || land_equals("Left Thumbstick Y", axis)) {
            controls.axis [ControlUp] [0] = ai;
            controls.axis [ControlUp] [1] = - 25;
            controls.axis [ControlDown] [0] = ai;
            controls.axis [ControlDown] [1] = 25;
        }
    }
    int bn = land_joystick_button_count();
    for (int bi = 1; bi < bn; bi += 1) {
        str button = land_joystick_button_name(bi);
        if (land_equals("B1", button)) {
            controls.button [ControlJump] = bi;
        }
        if (land_equals("B4", button)) {
            controls.button [ControlMenu] = bi;
        }
        if (land_equals("A", button)) {
            controls.button [ControlJump] = bi;
        }
        if (land_equals("Y", button)) {
            controls.button [ControlMenu] = bi;
        }
    }
}
void config_check_controls(Application * a) {
    for (int j = 0; j < ControlCount; j += 1) {
        controls.pressed [j] = ! controls.down [j];
        controls.down [j] = 0;
        controls.strength [j] = 0;
        for (int i = 0; i < 3; i += 1) {
            if (land_key(controls.c [j] [i])) {
                controls.down [j] = 1;
                controls.strength [j] = 1;
            }
        }
        //if controls.pressed[j]:
        //    print("control %d pressed (key %d)", j, controls.c[j][i])
        float threshold = controls.axis [j] [1] / 100.0;
        if (land_joystick_axis(controls.axis [j] [0]) * threshold > threshold * threshold) {
            controls.down [j] = 1;
            controls.strength [j] = fabs(land_joystick_axis(controls.axis [j] [0]));
        }
        if (land_joystick_button(controls.button [j])) {
            controls.down [j] = 1;
            controls.strength [j] = 1;
        }
        if (! controls.down [j]) {
            controls.pressed [j] = 0;
        }
    }
    a->left = controls.down [ControlLeft];
    a->right = controls.down [ControlRight];
    a->up = controls.down [ControlUp];
    a->down = controls.down [ControlDown];
    a->jump = controls.down [ControlJump];
    a->left_s = controls.strength [ControlLeft];
    a->right_s = controls.strength [ControlRight];
    a->up_s = controls.strength [ControlUp];
    a->down_s = controls.strength [ControlDown];
}
int config_joystick_control(int control, int progress) {
    int an = land_joystick_axis_count();
    if (progress == 0) {
        controls.axis [control] [0] = 0;
        controls.axis [control] [1] = 0;
        for (int ai = 1; ai < an; ai += 1) {
            controls.detection [ai] = 0;
            controls.zero [ai] = land_joystick_axis(ai);
        }
        controls.button [control] = 0;
    }
    for (int ai = 1; ai < an; ai += 1) {
        float a = land_joystick_axis(ai);
        float d = land_joystick_delta_axis(ai);
        controls.detection [ai] += fabs(d);
        if (fabs(a) > 0.2 && (progress == 0 || controls.detection [ai] > 0.5) && (fabs(d) > 0 || ai == controls.axis [control] [0])) {
            if (fabs(a * 25.0f) > fabs(controls.axis [control] [1] * 1.0f)) {
                controls.axis [control] [0] = ai;
                controls.axis [control] [1] = a * 25;
            }
            return FoundAxis;
        }
    }
    int bn = land_joystick_button_count();
    for (int bi = 1; bi < bn; bi += 1) {
        if (land_joystick_button_pressed(bi)) {
            controls.button [control] = bi;
            // initialize state for the new control
            controls.down [control] = 1;
            controls.pressed [control] = 0;
            return FoundButton;
        }
    }
    return FoundNothing;
}
void config_print_controls(LandFile * f) {
    for (int j = 0; j < ControlCount; j += 1) {
        land_file_print(f, "control %d %d %d", j, controls.c [j] [0], controls.c [j] [1]);
    }
}
void config_read_controls(str row) {
    if (land_starts_with(row, "control ")) {
        int a, b, c;
        sscanf(row, "control %d %d %d", & a, & b, & c);
        controls.c [a] [0] = b;
        controls.c [a] [1] = c;
    }
}
str control_name(int c) {
    if (controls.button [c]) {
        return land_joystick_button_name(controls.button [c]);
    }
    if (controls.axis [c] [0]) {
        return land_joystick_axis_name(controls.axis [c] [0]);
    }
    return "none";
}
